"""Initial Migration

Revision ID: 28099038d8d6
Revises: 
Create Date: 2024-09-23 00:10:33.591108

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import bookworm

# revision identifiers, used by Alembic.
revision: str = '28099038d8d6'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('book',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=512), nullable=False),
    sa.Column('uri', bookworm.database.models.DocumentUriDBType(length=1024), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_book_uri'), 'book', ['uri'], unique=True)
    op.create_table('document_position_info',
    sa.Column('last_page', sa.Integer(), nullable=True),
    sa.Column('last_position', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=512), nullable=False),
    sa.Column('uri', bookworm.database.models.DocumentUriDBType(length=1024), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_document_position_info_uri'), 'document_position_info', ['uri'], unique=True)
    op.create_table('note_tag',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=512), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_note_tag_title'), 'note_tag', ['title'], unique=True)
    op.create_table('pinned_document',
    sa.Column('last_opened_on', sa.DateTime(), nullable=True),
    sa.Column('is_pinned', sa.Boolean(), nullable=True),
    sa.Column('pinning_order', sa.Integer(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=512), nullable=False),
    sa.Column('uri', bookworm.database.models.DocumentUriDBType(length=1024), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_pinned_document_uri'), 'pinned_document', ['uri'], unique=True)
    op.create_table('quote_tag',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=512), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_quote_tag_title'), 'quote_tag', ['title'], unique=True)
    op.create_table('recent_document',
    sa.Column('last_opened_on', sa.DateTime(), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=512), nullable=False),
    sa.Column('uri', bookworm.database.models.DocumentUriDBType(length=1024), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_recent_document_uri'), 'recent_document', ['uri'], unique=True)
    op.create_table('bookmark',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=255), nullable=False),
    sa.Column('page_number', sa.Integer(), nullable=False),
    sa.Column('position', sa.Integer(), nullable=False),
    sa.Column('section_title', sa.String(length=1024), nullable=False),
    sa.Column('section_identifier', sa.String(length=1024), nullable=False),
    sa.Column('date_created', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.Column('book_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['book_id'], ['book.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('note',
    sa.Column('content', sa.Text(), nullable=False),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=255), nullable=False),
    sa.Column('page_number', sa.Integer(), nullable=False),
    sa.Column('position', sa.Integer(), nullable=False),
    sa.Column('section_title', sa.String(length=1024), nullable=False),
    sa.Column('section_identifier', sa.String(length=1024), nullable=False),
    sa.Column('date_created', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.Column('book_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['book_id'], ['book.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('quote',
    sa.Column('start_pos', sa.Integer(), nullable=False),
    sa.Column('end_pos', sa.Integer(), nullable=False),
    sa.Column('content', sa.Text(), nullable=False),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(length=255), nullable=False),
    sa.Column('page_number', sa.Integer(), nullable=False),
    sa.Column('position', sa.Integer(), nullable=False),
    sa.Column('section_title', sa.String(length=1024), nullable=False),
    sa.Column('section_identifier', sa.String(length=1024), nullable=False),
    sa.Column('date_created', sa.DateTime(), nullable=True),
    sa.Column('date_updated', sa.DateTime(), nullable=True),
    sa.Column('book_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['book_id'], ['book.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('notes_tags',
    sa.Column('note_id', sa.Integer(), nullable=True),
    sa.Column('note_tag_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['note_id'], ['note.id'], ),
    sa.ForeignKeyConstraint(['note_tag_id'], ['note_tag.id'], )
    )
    op.create_table('quotes_tags',
    sa.Column('quote_id', sa.Integer(), nullable=True),
    sa.Column('quote_tag_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['quote_id'], ['quote.id'], ),
    sa.ForeignKeyConstraint(['quote_tag_id'], ['quote_tag.id'], )
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('quotes_tags')
    op.drop_table('notes_tags')
    op.drop_table('quote')
    op.drop_table('note')
    op.drop_table('bookmark')
    op.drop_index(op.f('ix_recent_document_uri'), table_name='recent_document')
    op.drop_table('recent_document')
    op.drop_index(op.f('ix_quote_tag_title'), table_name='quote_tag')
    op.drop_table('quote_tag')
    op.drop_index(op.f('ix_pinned_document_uri'), table_name='pinned_document')
    op.drop_table('pinned_document')
    op.drop_index(op.f('ix_note_tag_title'), table_name='note_tag')
    op.drop_table('note_tag')
    op.drop_index(op.f('ix_document_position_info_uri'), table_name='document_position_info')
    op.drop_table('document_position_info')
    op.drop_index(op.f('ix_book_uri'), table_name='book')
    op.drop_table('book')
    # ### end Alembic commands ###
